# Pashizi Widget - WordPress Plugin Installation Guide

This comprehensive guide will help you install and configure the Pashizi Currency Exchange Widget on your WordPress website.

## Prerequisites

- WordPress 5.0 or higher
- PHP 7.4 or higher
- Active internet connection for real-time exchange rates

## Installation Methods

### Method 1: Direct File Upload (Recommended for Development)

1. **Download the Plugin**
   - Download or clone the plugin files to your local machine
   - Ensure you have the complete `pashizi_plugin` folder

2. **Upload to WordPress**
   - Access your WordPress installation via FTP, cPanel File Manager, or hosting control panel
   - Navigate to `/wp-content/plugins/`
   - Upload the entire `pashizi-widget` folder to the plugins directory
   - The structure should be: `/wp-content/plugins/pashizi-widget/`

3. **Activate the Plugin**
   - Log in to your WordPress admin panel
   - Go to **Plugins > Installed Plugins**
   - Find "Pashizi Currency Exchange Widget"
   - Click **Activate**

### Method 2: WordPress Admin Upload

1. **Prepare Plugin ZIP**
   - Create a ZIP file of the `pashizi-widget` folder
   - Ensure the main plugin file `pashizi-widget.php` is in the root of the ZIP

2. **Upload via WordPress Admin**
   - Log in to WordPress admin
   - Go to **Plugins > Add New**
   - Click **Upload Plugin**
   - Click **Choose File** and select your ZIP file
   - Click **Install Now**
   - Click **Activate Plugin**

### Method 3: WordPress.org Repository (Future)

*When available on WordPress.org repository:*

1. Go to **Plugins > Add New**
2. Search for "Pashizi Currency Exchange Widget"
3. Click **Install Now**
4. Click **Activate**

## Initial Configuration

### 1. Plugin Settings

After activation, configure the plugin:

1. Go to **Settings > Pashizi Widget**
2. Set your preferred:
   - **Default Currency**: Choose from 28+ supported currencies
   - **Default Language**: Select from 10 supported languages
3. Click **Save Changes**

### 2. Test the Installation

Add a test widget to verify everything works:

**Using Shortcode:**
1. Edit any post or page
2. Add: `[pashizi_widget currency="usd" lang="en"]`
3. Save and view the page
4. You should see the currency widget

## Usage Examples

### Basic Shortcode Usage

```php
// Simple widget with default settings
[pashizi_widget]

// USD widget in English
[pashizi_widget currency="usd" lang="en"]

// EUR widget in Persian (Farsi)
[pashizi_widget currency="eur" lang="fa"]

// GBP widget with custom CSS class
[pashizi_widget currency="gbp" lang="en" class="my-custom-widget"]
```

### WordPress Widget

1. Go to **Appearance > Widgets**
2. Find **Pashizi Currency Widget**
3. Drag it to your desired widget area
4. Configure:
   - Title (optional)
   - Currency
   - Language
   - Custom CSS Class (optional)
5. Save the widget

### Gutenberg Block

1. In the Gutenberg editor, click the **+** button
2. Search for "Pashizi Currency"
3. Add the block to your content
4. Use the sidebar panel to configure:
   - Currency selection
   - Language selection
5. The block will show a preview in the editor

## Advanced Configuration

### Custom Styling

Add custom CSS to your theme's style.css or via **Appearance > Customize > Additional CSS**:

```css
/* Style all Pashizi widgets */
[data-pashizi-widget] {
    border-radius: 10px;
    box-shadow: 0 4px 8px rgba(0,0,0,0.1);
    margin: 20px 0;
}

/* Style widgets with custom class */
.my-custom-widget {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    padding: 20px;
}
```

### Theme Integration

Add widgets directly to your theme files:

**In header.php:**
```php
<?php echo do_shortcode('[pashizi_widget currency="usd" lang="en"]'); ?>
```

**In sidebar.php:**
```php
<div class="currency-widget-sidebar">
    <?php echo do_shortcode('[pashizi_widget currency="eur" lang="fa"]'); ?>
</div>
```

## Troubleshooting

### Widget Not Displaying

**Issue**: Widget appears as empty space or doesn't load

**Solutions**:
1. Check browser console for JavaScript errors
2. Verify internet connection for API access
3. Ensure correct shortcode syntax
4. Try different currency/language combinations
5. Temporarily switch to a default WordPress theme to rule out theme conflicts

### Performance Issues

**Issue**: Page loads slowly with widget

**Solutions**:
1. Enable WordPress caching (WP Super Cache, W3 Total Cache)
2. Optimize your hosting server
3. Use a CDN service
4. Limit the number of widgets per page

### Styling Problems

**Issue**: Widget doesn't match your theme

**Solutions**:
1. Add custom CSS to override default styles
2. Use the `class` parameter to add custom styling hooks
3. Inspect widget HTML with browser developer tools
4. Check for theme CSS conflicts

### Language/RTL Issues

**Issue**: Persian or Arabic text not displaying correctly

**Solutions**:
1. Ensure your theme supports RTL languages
2. Add RTL CSS if needed:
   ```css
   [data-pashizi-widget][dir="rtl"] {
       text-align: right;
       direction: rtl;
   }
   ```
3. Verify proper UTF-8 encoding in your theme

## Plugin File Structure

```
pashizi-widget/
├── pashizi-widget.php          # Main plugin file
├── includes/
│   └── widget.php              # WordPress widget class
├── assets/
│   ├── js/
│   │   └── block.js            # Gutenberg block
│   └── css/
│       └── admin.css           # Admin styles
├── languages/
│   └── pashizi-widget-fa_IR.po # Persian translations
├── examples/
│   └── integration-examples.php # Usage examples
├── uninstall.php               # Plugin cleanup
├── README.md                   # Documentation
└── readme.txt                  # WordPress.org format
```

## Supported Parameters

### Shortcode Parameters

| Parameter | Description | Default | Examples |
|-----------|-------------|---------|----------|
| `currency` | Currency code | `usd` | `usd`, `eur`, `gbp`, `jpy` |
| `lang` | Language code | `en` | `en`, `fa`, `ar`, `de` |
| `class` | Custom CSS class | - | `my-widget`, `sidebar-currency` |
| `id` | Custom HTML ID | - | `header-widget`, `main-currency` |

### Supported Currencies

`usd`, `eur`, `gbp`, `jpy`, `chf`, `cad`, `aud`, `sgd`, `hkd`, `nok`, `sek`, `dkk`, `myr`, `rub`, `try`, `inr`, `cny`, `aed`, `thb`, `qar`, `sar`, `omr`, `bhd`, `kwd`, `iqd`, `azn`, `afn`, `amd`

### Supported Languages

- `en` - English
- `fa` - Persian (فارسی)
- `de` - German (Deutsch)
- `ar` - Arabic (العربية)
- `es` - Spanish (Español)
- `fr` - French (Français)
- `it` - Italian (Italiano)
- `nl` - Dutch (Nederlands)
- `ru` - Russian (Русский)
- `zh` - Chinese (中文)

## Uninstalling

### Deactivation
1. Go to **Plugins > Installed Plugins**
2. Find "Pashizi Currency Exchange Widget"
3. Click **Deactivate**

### Complete Removal
1. Deactivate the plugin first
2. Click **Delete** on the plugin
3. Confirm deletion
4. The `uninstall.php` script will automatically clean up all plugin data

## Support and Updates

- **Documentation**: Check the README.md file
- **Examples**: See `examples/integration-examples.php`
- **Issues**: Check the troubleshooting section above
- **Pashizi Service**: Visit [www.pashizi.com](https://www.pashizi.com)

## Security Notes

- The plugin only connects to `widget.pashizi.com/calculator` for exchange rate data
- No personal user data is collected or transmitted
- All user inputs are properly sanitized and escaped
- The plugin follows WordPress security best practices

## Performance Notes

- Scripts only load on pages containing the widget
- Exchange rate data is cached for optimal performance
- Widget assets are served from a fast CDN
- Compatible with major caching plugins

---

**Need Help?** If you encounter any issues during installation or setup, refer to the troubleshooting section or check the plugin documentation.
