# Pashizi Currency Exchange Widget - WordPress Plugin

A comprehensive WordPress plugin for displaying real-time Iranian Rial (IRR) currency exchange rates with an interactive calculator. Built for the Pashizi widget service.

## Features

- **Real-time Exchange Rates**: Display live buy/sell prices for various currencies against Iranian Rial
- **Interactive Calculator**: Allow users to calculate currency conversions
- **Multi-currency Support**: Supports 28+ major world currencies including USD, EUR, GBP, JPY, and more
- **Multi-language Support**: Available in 10 languages including Persian (Farsi), English, Arabic, and more
- **Multiple Integration Methods**: Shortcode, Widget, and Gutenberg Block support
- **Responsive Design**: Mobile-friendly and responsive layout
- **Persian/RTL Support**: Full right-to-left language support for Persian and Arabic

## Supported Currencies

USD, EUR, GBP, JPY, CHF, CAD, AUD, SGD, HKD, NOK, SEK, DKK, MYR, RUB, TRY, INR, CNY, AED, THB, QAR, SAR, OMR, BHD, KWD, IQD, AZN, AFN, AMD

## Supported Languages

- English (en)
- Persian/Farsi (fa) - فارسی
- German (de) - Deutsch
- Arabic (ar) - العربية
- Spanish (es) - Español
- French (fr) - Français
- Italian (it) - Italiano
- Dutch (nl) - Nederlands
- Russian (ru) - Русский
- Chinese (zh) - 中文

## Installation

### Method 1: Upload Plugin Files

1. Download the plugin files
2. Upload the `pashizi-widget` folder to your WordPress `/wp-content/plugins/` directory
3. Activate the plugin through the 'Plugins' menu in WordPress
4. Configure default settings in Settings > Pashizi Widget

### Method 2: WordPress Admin Upload

1. Go to Plugins > Add New in your WordPress admin
2. Click "Upload Plugin"
3. Select the plugin ZIP file
4. Click "Install Now" and then "Activate"

## Usage

### 1. Shortcode

Use the `[pashizi_widget]` shortcode in any post or page:

```php
[pashizi_widget currency="usd" lang="en"]
```

**Parameters:**
- `currency`: Currency code (default: usd)
- `lang`: Language code (default: en)
- `class`: Custom CSS class
- `id`: Custom HTML ID

**Examples:**
```php
[pashizi_widget currency="eur" lang="fa"]
[pashizi_widget currency="gbp" lang="en" class="my-custom-class"]
[pashizi_widget currency="usd" lang="ar" id="header-widget"]
```

### 2. WordPress Widget

1. Go to **Appearance > Widgets** (or **Appearance > Customize > Widgets** for Customizer)
2. Add the **"Pashizi Currency Widget"** to any widget area
3. Configure the currency and language settings
4. Save the widget

### 3. Gutenberg Block

1. In the Gutenberg editor, click the "+" button to add a new block
2. Search for "Pashizi Currency"
3. Add the block to your content
4. Use the sidebar panel to configure currency and language settings

### 4. PHP Code (for themes)

```php
<?php
// Display widget with default settings
echo do_shortcode('[pashizi_widget]');

// Display widget with custom settings
echo do_shortcode('[pashizi_widget currency="eur" lang="fa"]');
?>
```

## Configuration

### Plugin Settings

Navigate to **Settings > Pashizi Widget** to configure:

- **Default Currency**: Set the default currency for new widgets
- **Default Language**: Set the default language for new widgets

### Widget Parameters

| Parameter | Description | Default | Options |
|-----------|-------------|---------|---------|
| `currency` | Currency to display | `usd` | usd, eur, gbp, jpy, chf, cad, aud, sgd, hkd, nok, sek, dkk, myr, rub, try, inr, cny, aed, thb, qar, sar, omr, bhd, kwd, iqd, azn, afn, amd |
| `lang` | Interface language | `en` | en, fa, de, ar, es, fr, it, nl, ru, zh |
| `class` | Custom CSS class | - | Any valid CSS class name |
| `id` | Custom HTML ID | - | Any valid HTML ID |

## Customization

### CSS Styling

The widget uses the CSS class `pashizi-widget` and can be customized with CSS:

```css
/* Custom styling for all widgets */
[data-pashizi-widget] {
    border-radius: 10px;
    box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
}

/* Custom styling for specific widget */
.my-custom-widget {
    background-color: #f0f0f0;
    padding: 20px;
}
```

### RTL Support

The widget automatically detects RTL languages (Persian, Arabic) and adjusts the layout accordingly. No additional configuration is needed.

## Performance

- **Lightweight**: Minimal impact on page load times
- **Efficient Loading**: Scripts only load when widgets are present on the page
- **CDN Delivery**: Widget assets are delivered from a fast CDN
- **Caching Friendly**: Compatible with WordPress caching plugins

## Troubleshooting

### Widget Not Displaying

1. Check that the plugin is activated
2. Ensure the shortcode syntax is correct
3. Verify the currency and language codes are supported
4. Check for JavaScript conflicts in browser console

### Styling Issues

1. Check for theme CSS conflicts
2. Use browser developer tools to inspect the widget elements
3. Add custom CSS to override theme styles
4. Ensure proper RTL support for Persian/Arabic languages

### Performance Issues

1. Check if multiple widgets are loading unnecessary scripts
2. Consider using a caching plugin
3. Optimize your WordPress installation

## Support

For support, bug reports, or feature requests:

- Plugin Support: Check WordPress plugin support forums
- Pashizi Service: Visit [www.pashizi.com](https://www.pashizi.com)
- Technical Issues: Refer to the troubleshooting section above

## Privacy and Data

The widget connects to Pashizi's API to fetch real-time exchange rates. No personal data is collected or stored by the plugin. Exchange rate data is cached for performance optimization.

## Changelog

### Version 1.0.0
- Initial release
- Shortcode support
- WordPress widget support
- Gutenberg block support
- Multi-language support (10 languages)
- Multi-currency support (28+ currencies)
- Admin settings panel
- RTL language support
- Persian (Farsi) translations

## License

This plugin is licensed under the GPL v2 or later.

---

**Powered by [Pashizi](https://www.pashizi.com)** - Iran's leading currency exchange rate service.
