(function(blocks, element, components, editor) {
    var el = element.createElement;
    var registerBlockType = blocks.registerBlockType;
    var SelectControl = components.SelectControl;
    var PanelBody = components.PanelBody;
    var InspectorControls = editor.InspectorControls;

    var currencies = [
        { label: 'USD - US Dollar', value: 'usd' },
        { label: 'EUR - Euro', value: 'eur' },
        { label: 'GBP - British Pound', value: 'gbp' },
        { label: 'JPY - Japanese Yen', value: 'jpy' },
        { label: 'CHF - Swiss Franc', value: 'chf' },
        { label: 'CAD - Canadian Dollar', value: 'cad' },
        { label: 'AUD - Australian Dollar', value: 'aud' },
        { label: 'SGD - Singapore Dollar', value: 'sgd' },
        { label: 'HKD - Hong Kong Dollar', value: 'hkd' },
        { label: 'NOK - Norwegian Krone', value: 'nok' },
        { label: 'SEK - Swedish Krona', value: 'sek' },
        { label: 'DKK - Danish Krone', value: 'dkk' },
        { label: 'MYR - Malaysian Ringgit', value: 'myr' },
        { label: 'RUB - Russian Ruble', value: 'rub' },
        { label: 'TRY - Turkish Lira', value: 'try' },
        { label: 'INR - Indian Rupee', value: 'inr' },
        { label: 'CNY - Chinese Yuan', value: 'cny' },
        { label: 'AED - UAE Dirham', value: 'aed' },
        { label: 'THB - Thai Baht', value: 'thb' },
        { label: 'QAR - Qatari Riyal', value: 'qar' },
        { label: 'SAR - Saudi Riyal', value: 'sar' },
        { label: 'OMR - Omani Rial', value: 'omr' },
        { label: 'BHD - Bahraini Dinar', value: 'bhd' },
        { label: 'KWD - Kuwaiti Dinar', value: 'kwd' },
        { label: 'IQD - Iraqi Dinar', value: 'iqd' },
        { label: 'AZN - Azerbaijani Manat', value: 'azn' },
        { label: 'AFN - Afghan Afghani', value: 'afn' },
        { label: 'AMD - Armenian Dram', value: 'amd' }
    ];

    var languages = [
        { label: 'English', value: 'en' },
        { label: 'Persian (فارسی)', value: 'fa' },
        { label: 'German (Deutsch)', value: 'de' },
        { label: 'Arabic (العربية)', value: 'ar' },
        { label: 'Spanish (Español)', value: 'es' },
        { label: 'French (Français)', value: 'fr' },
        { label: 'Italian (Italiano)', value: 'it' },
        { label: 'Dutch (Nederlands)', value: 'nl' },
        { label: 'Russian (Русский)', value: 'ru' },
        { label: 'Chinese (中文)', value: 'zh' }
    ];

    registerBlockType('pashizi/currency-widget', {
        title: 'Pashizi Currency Widget',
        description: 'Display real-time currency exchange rates with an interactive calculator.',
        icon: 'money-alt',
        category: 'widgets',
        attributes: {
            currency: {
                type: 'string',
                default: 'usd'
            },
            lang: {
                type: 'string',
                default: 'en'
            }
        },

        edit: function(props) {
            var attributes = props.attributes;
            var setAttributes = props.setAttributes;

            function onChangeCurrency(newCurrency) {
                setAttributes({ currency: newCurrency });
            }

            function onChangeLanguage(newLanguage) {
                setAttributes({ lang: newLanguage });
            }

            return [
                el(InspectorControls, {},
                    el(PanelBody, { title: 'Widget Settings' },
                        el(SelectControl, {
                            label: 'Currency',
                            value: attributes.currency,
                            options: currencies,
                            onChange: onChangeCurrency
                        }),
                        el(SelectControl, {
                            label: 'Language',
                            value: attributes.lang,
                            options: languages,
                            onChange: onChangeLanguage
                        })
                    )
                ),
                el('div', { className: props.className },
                    el('div', {
                        style: {
                            border: '2px dashed #ccc',
                            padding: '20px',
                            textAlign: 'center',
                            backgroundColor: '#f9f9f9'
                        }
                    },
                        el('h4', { style: { margin: '0 0 10px 0' } }, 'Pashizi Currency Widget'),
                        el('p', { style: { margin: '0', color: '#666' } }, 
                            'Currency: ' + attributes.currency.toUpperCase() + ' | Language: ' + attributes.lang.toUpperCase()
                        ),
                        el('p', { style: { margin: '10px 0 0 0', fontSize: '12px', color: '#999' } }, 
                            'Widget will be displayed on the frontend'
                        )
                    )
                )
            ];
        },

        save: function() {
            return null; // Dynamic block, rendered on server-side
        }
    });
})(
    window.wp.blocks,
    window.wp.element,
    window.wp.components,
    window.wp.editor
);
