<?php
/**
 * Uninstall script for Pashizi Widget
 * 
 * This file is executed when the plugin is deleted from WordPress admin.
 * It cleans up all plugin data and settings.
 */

// If uninstall not called from WordPress, exit
if (!defined('WP_UNINSTALL_PLUGIN')) {
    exit;
}

// Delete plugin options
delete_option('pashizi_widget_options');

// Clean up any transients (cached data) if they exist
delete_transient('pashizi_widget_cache');

// Remove any user meta related to the plugin
delete_metadata('user', 0, 'pashizi_widget_preferences', '', true);

// Clean up any custom database tables if they were created (none in this plugin)
// global $wpdb;
// $wpdb->query("DROP TABLE IF EXISTS {$wpdb->prefix}pashizi_widget_data");

// Clear any scheduled events if they exist
wp_clear_scheduled_hook('pashizi_widget_daily_cleanup');

// Remove any custom capabilities if they were added
// remove_cap('administrator', 'manage_pashizi_widgets');

// Clean up uploaded files if any (none in this plugin)
// $upload_dir = wp_upload_dir();
// $plugin_uploads = $upload_dir['basedir'] . '/pashizi-widget/';
// if (is_dir($plugin_uploads)) {
//     rmdir($plugin_uploads);
// }

// Log the uninstallation (optional, for debugging)
